/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#include "Filter_Dump.h"

/*Betekenis van de flags van Protect member
bron http://msdn.microsoft.com/en-us/library/windows/desktop/aa366786(v=vs.85).aspx
*/
char* pageNames[32] = {"Disabled", //0x1
	"Leesbaar", //0x2
	"Lees- en schrijfbaar", //0x4
	"Lees- en schrijfbaar", //0x8
	"Uitvoerbaar (code)", //0x10
	"Uitvoer- en leesbaar (code)", //0x20
	"lees-, schrijf en uitvoerbaar", //0x40
	"lees-, schrijf en uitvoerbaar", //0x80
	"PAGE_GUARD", //0x100
	"PAGE_NOCACHE", //0x200
	"PAGE_WRITECOMBINE", //0x400
	"","","","","","","","","","","","","","","","","","","","",""};

/*Roep CreateMemoryDump aan en schrijf de een header voor een index-bestand in optionalOutputFile*/
DUMP_SESSION* CreateDumpIndexMemoryDump(char* outputDir, char* outputFile, char* optionalOutputFile, int flags) {
	int writtenBytes=0;
	DUMP_SESSION* newdump;

	newdump = CreateMemoryDump(outputDir, outputFile, optionalOutputFile, flags);
	if(optionalOutputFile!=0)
		WriteFile(newdump->optionalDumpFile,"Module              Dump Address  Virtual Address	Size\r\n", strlen("Module              Dump Address  Virtual Address	Size\r\n"), (LPDWORD) &writtenBytes, NULL);

	return newdump;
}

DUMP_SESSION* InitiateDumpSmall(char* location, char* argument, int analyse_type) {
	return CreateDumpIndexMemoryDump(location, "small_dump.txt", "small_dump_index.txt", DS_WRITE_LOCATION_STRING);
}

DUMP_SESSION* InitiateDumpBig(char* location, char* argument, int analyse_type) {
	return CreateMemoryDump(location, "big_dump.txt", 0, DS_WRITE_UNREADABLE_DATA_TO_DUMP);
}

void DestroyDump(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

//Deze methode schrijft een volledige memorydump naar een bestand
void WriteMemoryDump(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	char* moveBuff=buff;
	int writtenBytes;
	memlong curPos=0;
	int i;

	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {

		/*Niet al het virtuele geheugen dat een applicatie tot zijn beschikking heeft wordt door deze applicatie gebruikt
		Met flag DS_WRITE_UNREADABLE_DATA_TO_DUMP wordt deze ruimte opgevuld met '0' bytes*/
		if(dmp->unlocated_size!=0 && dmp->flags&DS_WRITE_UNREADABLE_DATA_TO_DUMP) {
			while(dmp->unlocated_size!=0) {
				WriteFile(dmp->dumpFile, dmp->zerobuf, (dmp->unlocated_size<1000 ? dmp->unlocated_size : 1000), (LPDWORD) &writtenBytes, NULL);
				dmp->unlocated_size -= writtenBytes;
			}
			dmp->unlocated_size = 0;
		}
		
		/*Schrijf de pointer van het bestand en virtuele geheugen weg indien nodig.
		Op deze manier kan teruggerekend worden 
		*/
		if(dmp->flags&DS_WRITE_LOCATION_STRING) {
			GetFileSizeEx(dmp->dumpFile, (PLARGE_INTEGER) &curPos); //Krijg de huidige positie van het bestand

			if(dmp->optionalDumpFile!=0 && process !=0) {
				/*Doe een poging te achterhalen welke module dit geheugen heeft aangevraagt.*/
				if(GetModuleFileNameEx(process, (HMODULE) memInfo->AllocationBase, dmp->string_location, 1000)!=0
					|| GetModuleFileNameEx(process, (HMODULE) memInfo->BaseAddress, dmp->string_location, 1000)!=0) {
					char* fileName=dmp->string_location;
					fileName += strlen(fileName);

					while(*fileName!='\\' && *fileName!='/')
						fileName--;

					fileName++;

					WriteFile(dmp->optionalDumpFile, fileName, strlen(fileName), (LPDWORD) &writtenBytes, NULL);

					if(strlen(fileName)<20)
						for(i=0; i<20-strlen(fileName); i++)
							WriteFile(dmp->optionalDumpFile, " ", strlen(" "), (LPDWORD) &writtenBytes, NULL);
				} else {
					WriteFile(dmp->optionalDumpFile, "                    ", 20, (LPDWORD) &writtenBytes, NULL);
				}

				sprintf(dmp->string_location, "0x%p	  0x%p-0x%p	%d	"
					,curPos //Positie in bestand
					,memInfo->BaseAddress //Virtueel geheugen positie
					,(SIZE_T)memInfo->BaseAddress + memInfo->RegionSize //Virtueel geheugen positie einde regio
					,memInfo->RegionSize //Regio grootte
					);

				flagsToStr(memInfo->Protect, pageNames, dmp->string_location); //Zet de flags om is een leesbare string

				WriteFile(dmp->optionalDumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);

				WriteFile(dmp->optionalDumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);
			} else {
				sprintf(dmp->string_location, "\n\n[Base address: %d, Region: %d]\n", memInfo->BaseAddress, memInfo->RegionSize);
				WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
			}
		}

		WriteFile(dmp->dumpFile, buff, memInfo->RegionSize, (LPDWORD) &writtenBytes, NULL);
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}
}

/*Deze gaat elke mogelijke flag af, staat deze aan in 'inFlags' 
dan zal de bijbehorende string uit inStr gehaald worden en geschreven worden in out*/
void flagsToStr(int inFlags, char* inStr[], char*out) {
	int currentFlag=1;
	int countFlag=0;
	int firstFlagFound=0;

	while(inFlags!=0) {
		if(inFlags&currentFlag //Is deze flag aan in inFlags?
		&& *inStr[countFlag]!=0) {  //Is er een naam voor deze flag beschikbaar
			if(firstFlagFound) //Zet een komma indien dit niet de eerste gevonden flag is
				strcat(out, ", ");

			strcat(out, inStr[countFlag]); //Schrijf de naam van de flag weg

			firstFlagFound|=1; //De eerste flag in gevonden
			inFlags^=currentFlag; //Haal de flag uit inFlags
		}
		currentFlag*=2; //Ga naar de volgende flag
		countFlag++;
	}
}